# extension/

Browser extension source (Firefox + Chrome) for capturing console logs and network requests.

## Files

- **`background.js`** — WebTransport connection, config management, main event loop.
- **`commands.js`** — Server command handlers (screenshot, click, navigate, fill, getText, executeJs).
- **`capture.js`** — Console/network log capture, content script message relay.
- **`codec.js`** — Binary WebTransport protocol (matches `perch/src/web/webtransport/codec.rs`).
- **`injected.js`** — Content script injected into pages for console interception.
- **`content.js`** — Content script bridge between injected.js and background.js.
- **`popup/`** — Extension popup UI for configuration.

## Manifests

- `manifest.chrome.json` — Chrome manifest v3
- `manifest.firefox.json` — Firefox manifest v3 (with `browser_specific_settings`)

Built extensions are served dynamically by the Perch server at `/extension.xpi` and `/extension.zip`.
